/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.nmos6502.commands;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.nmos6502.Command;
import emulator.hardware.nmos6502.CommandSet;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Flags6502;
import emulator.hardware.nmos6502.Operand;
import emulator.hardware.nmos6502.operands.Absolute;
import emulator.hardware.nmos6502.operands.AbsoluteX;
import emulator.hardware.nmos6502.operands.AbsoluteY;
import emulator.hardware.nmos6502.operands.Immediate;
import emulator.hardware.nmos6502.operands.IndirectX;
import emulator.hardware.nmos6502.operands.IndirectY;
import emulator.hardware.nmos6502.operands.ZeroPage;
import emulator.hardware.nmos6502.operands.ZeroPageX;

public class AND
implements Command {
    @Override
    public void execute(Cpu6502 cpu, Operand operand) throws EmulatorException {
        int accu_old = (int)cpu.getAccu().getNumber();
        Flags6502 flags = cpu.getFlags();
        int accu = accu_old & (int)operand.getByte().getNumber();
        flags.setNZFromValue(accu);
        cpu.setAccu(new HwByte((long)accu));
        cpu.setFlags(flags);
    }

    @Override
    public String getName() {
        return "AND";
    }

    @Override
    public void register(CommandSet cset) {
        cset.defineCommand(41, this, new Immediate());
        cset.defineCommand(37, this, new ZeroPage());
        cset.defineCommand(53, this, new ZeroPageX());
        cset.defineCommand(45, this, new Absolute());
        cset.defineCommand(61, this, new AbsoluteX());
        cset.defineCommand(57, this, new AbsoluteY());
        cset.defineCommand(33, this, new IndirectX());
        cset.defineCommand(49, this, new IndirectY());
    }
}

